//
//  LandingVC.swift
//  MultiInstancesApp
//
//  Created by Abdul on 07/03/19.
//  Copyright © 2019 Abdul. All rights reserved.
//

import UIKit
import NielsenAppApi

class LandingVC: UIViewController, NielsenAppApiDelegate {
    
    var nielsenMain : NielsenAppApi!
    var sdkMethods : SDKMethods!
    var data : [String : Any]!
    var subBrandAInitCount : Int!
    var subBrandBInitCount : Int!
    var nielsenApiA : NielsenAppApi!
    var nielsenApiB : NielsenAppApi!
    var AppLoaded = 0
    
    @IBOutlet weak var btnSubBrandA: UIButton!
    @IBOutlet weak var btnSubBrandB: UIButton!
    
    @IBOutlet weak var SDKVersion: UILabel!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.view.backgroundColor = UIColor(patternImage: UIImage(named: "new_ios_bg.png")!)
        
        self.nielsenMain = NielsenInit.createMainBrandApi(delegate: self)
        
        SDKVersion.text = "SDK Version: " + self.nielsenMain.meterVersion
        sdkMethods = SDKMethods()
        
        setButtonBorderColor(button: btnSubBrandA)
        setButtonBorderColor(button: btnSubBrandB)
        
        subBrandAInitCount = 0
        subBrandBInitCount = 0
    }
    
    
    override func viewDidAppear(_ animated: Bool) {
        
        self.data = sdkMethods.loadStaticMaster()
        self.nielsenMain.loadMetadata(self.data)
        NSLog("Fired Main Static Event")
    }
    
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        print("prepare")
        let videoController = segue.destination as? ViewController
        videoController?.nielsenMain = nielsenMain
        if segue.identifier == "segSubBrandA" {
            //  let videoController = segue.destination as? ViewController
            videoController?.videoType = Constants.subBrandA
            //  videoController?.nielsenMain = nielsenMain
            if(subBrandAInitCount == 0){
                //Mark: In NielsenInit class we are initialising the (SubBrandA) NielsenApi.
                nielsenApiA = NielsenInit.createSubBrandAApi(delegate: self)
                subBrandAInitCount = 1
            }
            videoController?.nielsenApi = nielsenApiA
            
        }else if segue.identifier == "segSubBrandB" {
            //    let videoController = segue.destination as? ViewController
            videoController?.videoType = Constants.subBrandB
            //    videoController?.nielsenMain = nielsenMain
            if(subBrandBInitCount == 0){
                //Mark: In NielsenInit class we are initialising the (SubBrandB) NielsenApi.
                nielsenApiB = NielsenInit.createSubBrandBApi(delegate: self)
                subBrandBInitCount = 1
            }
            videoController?.nielsenApi = nielsenApiB
        }
    }
    
    func setButtonBorderColor(button : UIButton){
        
        button.layer.borderColor = UIColor.white.cgColor
    }
}

