package com.nielsen.simple_noads_android_8100.activities;

import android.annotation.TargetApi;
import android.os.Bundle;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.nielsen.app.sdk.AppSdk;
import com.nielsen.app.sdk.IAppNotifier;
import com.nielsen.app.sdk.NielsenAppSDKJSHandler;
import com.nielsen.simple_noads_android_8100.R;

public class WebViewActivity extends AppCompatActivity implements IAppNotifier {

    WebView webView;
    AppSdk appSdk;
    NielsenAppSDKJSHandler jsAppSDK;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_optout);
        webView = (WebView) findViewById(R.id.webView);

        webView.getSettings().setJavaScriptEnabled(true);

        webView.setWebViewClient(new WebViewClient() {
            @SuppressWarnings("deprecation")
            @Override
            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                Toast.makeText(WebViewActivity.this, description, Toast.LENGTH_SHORT).show();
            }
            @TargetApi(android.os.Build.VERSION_CODES.M)
            @Override
            public void onReceivedError(WebView view, WebResourceRequest req, WebResourceError rerr) {
                // Redirect to deprecated method, so you can use it in all SDK versions
                onReceivedError(view, rerr.getErrorCode(), rerr.getDescription().toString(), req.getUrl().toString());
            }
        });

        String url = "https://nielsenonlinesupport.com/colin/sdk3/govardhan/videojs.htm";
        jsAppSDK = new NielsenAppSDKJSHandler(this, "ggPM");
       // jsAppSDK = webView.con
        webView.loadUrl(url);
    }

    @Override
    public void onAppSdkEvent(long l, int i, String s) {

    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (appSdk != null)
        {
            appSdk.close();
            appSdk = null;
        }
    }
}