//
//  WebViewVC.swift
//  simple_no_ad_sdk
//
//  Created by Abdul Rafay Mohd on 06/01/21.
//

import UIKit
import WebKit
import NielsenAppApi

class WebViewVC: UIViewController, NielsenAppApiDelegate, WKNavigationDelegate {
    
    var webView: WKWebView!
    var nielsenApi: NielsenAppApi!
    var urlString: String?
    var isOptIn : Bool!
    let jsFunctionNativeMessage = "NielsenSDKMsg"

    var jsAppSDK: NielsenAppSDKJSHandler?
    
    override func loadView() {
        webView = WKWebView()
        webView.navigationDelegate = self
        view = webView
    }
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
 self.view.backgroundColor = UIColor(patternImage: UIImage(named: "new_background.jpg")!)
        let url = URL(string: "https://nielsenonlinesupport.com/colin/sdk3/govardhan/videojs.htm")!
        self.jsAppSDK=NielsenAppSDKJSHandler(apiType: "ggPM")
        if let jsAppSDK = self.jsAppSDK{
            self.webView?.configuration.userContentController.add(jsAppSDK, name: "NielsenSDKMsg")
            webView.load(URLRequest(url: url))
            webView.allowsBackForwardNavigationGestures = true
        }
}
    deinit {
        if let webView = self.webView {
            webView.configuration.userContentController.removeScriptMessageHandler(forName: jsFunctionNativeMessage)
        }
        self.jsAppSDK = nil
        if let webView = self.webView {
            webView.removeFromSuperview()
        }
        self.webView = nil
    }
}

