//
//  OptOutVC.swift
//  StandardSDK6003Swift
//
//  Created by Abdul on 17/04/18.
//  Copyright © 2018 Abdul. All rights reserved.
//

import UIKit
import WebKit
import NielsenAppApi

@objc(WKWebViewController)
class OptOutVC: UIViewController, NielsenAppApiDelegate, WKNavigationDelegate {
    

    weak var webView: WKWebView?
    
    let jsFunctionNativeMessage = "nativeMsg"

    var jsAppSDK: NielsenAppSDKJSHandler?
    var apiType: String?
    var urlString: String?
     var webPageUrl:String?

    func addWebView() {
        let configuration = WKWebViewConfiguration()
        configuration.allowsInlineMediaPlayback = true

        let webView = WKWebView(frame: .zero, configuration: configuration)
        webView.translatesAutoresizingMaskIntoConstraints = false
        webContainerView.addSubview(webView)

        self.webView = webView
        webContainerView.addConstraints(NSLayoutConstraint.constraints(
            withVisualFormat: "V:|-0-[webView]-0-|",
            options: .directionLeadingToTrailing,
            metrics: nil,
            views: ["webView":webView]))
        webContainerView.addConstraints(NSLayoutConstraint.constraints(
            withVisualFormat: "H:|-0-[webView]-0-|",
            options: .directionLeadingToTrailing,
            metrics: nil,
            views: ["webView":webView]))
    }

    override func viewDidLoad() {
        super.viewDidLoad()
       
         webPageUrl = "https://nielsenonlinesupport.com/colin/sdk3/govardhan/videojs.htm"
        if self.responds(to: #selector(setter: edgesForExtendedLayout)) {
            self.edgesForExtendedLayout = .init(rawValue: 0)
        }
        
        addWebView()
        
        if let sdk = NielsenAppSDKJSHandler(apiType: self.apiType) {
            self.jsAppSDK = sdk
            if let webView = self.webView, let urlString = self.urlString {
                webView.configuration.userContentController.add(sdk, name: jsFunctionNativeMessage)
                if let url = URL(string: urlString) {
                    webView.load(URLRequest(url: url))
                }
            }
        }
    }
    
    deinit {
        if let webView = self.webView {
            webView.configuration.userContentController.removeScriptMessageHandler(forName: jsFunctionNativeMessage)
        }
        self.jsAppSDK = nil
        if let webView = self.webView {
            webView.removeFromSuperview()
        }
        self.webView = nil
    }
}
