//
//  LandingVC.swift
//  StandardSDK6003Swift
//
//  Created by Abdul on 17/04/18.
//  Copyright © 2018 Abdul. All rights reserved.
//

import UIKit
import NielsenAppApi


class LandingVC: UIViewController, NielsenAppApiDelegate {
    
    @IBOutlet weak var btnOnlyContent: UIButton!
    @IBOutlet weak var btnContentWithAd: UIButton!
    @IBOutlet weak var btnDtvr: UIButton!
    @IBOutlet weak var btnPrivacy: UIButton!
    @IBOutlet weak var lblIpAdress: UILabel! 
    @IBOutlet weak var lblSDKVersion: UITextField!
    
    @IBOutlet weak var btnWebview: UIButton!
    @IBOutlet weak var lblOpt: UILabel!
    @IBOutlet weak var lblText: UILabel!
    @IBOutlet weak var switchOpt: UISwitch!
    
    var nielsenApi : NielsenAppApi!
    var sdkMethods : SDKMethods!
    var data : [String : Any]!
    var ipAddress:String?
    var odd : Int = 1
    var AppLoaded = 0
    var isOptIn : Bool!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.view.backgroundColor = UIColor(patternImage: UIImage(named: "new_background.jpg")!)
        
        setButtonBorderColor(button: btnOnlyContent)
        setButtonBorderColor(button: btnContentWithAd)
        setButtonBorderColor(button: btnDtvr)
        setButtonBorderColor(button: btnPrivacy)
        setButtonBorderColor(button: btnWebview)
        
        
        if(AppLoaded == 0){

        //Getting the instance of NielsenApi
         self.nielsenApi = NielsenInit.createNielsenApi(delegate: self)
        lblSDKVersion.text = "SDK Version: " + self.nielsenApi.meterVersion
         AppLoaded += 1
         sdkMethods = SDKMethods()
         self.data = sdkMethods.loadStaticMaster()
         self.nielsenApi.loadMetadata(self.data)
        }
        isOptIn = true
    }
 
    override func viewDidAppear(_ animated: Bool) {
        
 //       self.data = sdkMethods.loadStaticMaster()
 //       self.nielsenApi.loadMetadata(self.data)
        
 //       print("Fired Main Static Event")
    }
    
    
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
          
        if segue.identifier == "segContent" {
            let videoController = segue.destination as? ViewController
            videoController?.videoType = Constants.onlyContent
            videoController?.totalVideos = 1
            videoController?.isOptIn = self.isOptIn
             videoController?.nielsenApi = nielsenApi
            
        }else if segue.identifier == "segContentAndAd" {
            let videoController = segue.destination as? ViewController
            videoController?.videoType = Constants.contentWithOneAd
            videoController?.totalVideos = 2
            videoController?.isOptIn = self.isOptIn
             videoController?.nielsenApi = nielsenApi
            
        }else if segue.identifier == "segDTVR" {
            
            let videoController = segue.destination as? ViewController
            videoController?.videoType = Constants.dtvrVideo
            videoController?.totalVideos = 1
            videoController?.isOptIn = self.isOptIn
             videoController?.nielsenApi = nielsenApi
            
        }else if segue.identifier == "segWebview" {
            let videoController = segue.destination as? OptOutVC
            videoController?.isOptIn = self.isOptIn
             videoController?.nielsenApi = nielsenApi
           
        }
        
    }
    
    @IBAction func switchOptValueChanged(_ sender: UISwitch) {
        
        if(sender.isOn){
            lblText.isHidden = false
            isOptIn = false
        }else{
            lblText.isHidden = true
            isOptIn = true
        }
    }
    
    func setButtonBorderColor(button : UIButton){
        
        button.layer.borderColor = UIColor.white.cgColor
    }
    
    
    
    

    
}
