//
//  SDKMethods.swift
//  StandardSDK6003Swift
//
//  Created by Abdul on 17/04/18.
//  Copyright © 2018 Abdul. All rights reserved.
//

import Foundation

class SDKMethods : NSObject {
    
    var url = NSURL(string: "")
    
    func loadStaticMaster() -> [String : Any] {
        
        //Loading Static Main data
        let SegNumber = Int.random(in: 0 ... 1000)
        let staticData =
            [
                "type": "static",
                "assetid" : "AA\(SegNumber)",
                "section": "Section\(SegNumber)",
                "segA": "segmentA",
                "segB": "segmentB",
                "segC": "segmentC"
        ]
        
        return staticData
        
    }
    func setContentUrl() -> String {
        
        //Loading Content URL
        let c = "CanyouNameaCountry.mp4"
        url = NSURL(string: "http://www.nielsenonlinesupport.com/colin/sdk3/assets/CanYouNameaCountry.mp4")
        
        return c
    }
    
    
    func setAdUrl() -> String {
        
        //Loading Ad URL
        let show = ["sw-trailor.mp4","GeicoMeteor.mp4","sw-trailor.mp4","Overflowing.mp4","Grandpa.mp4","sw-trailor.mp4","Hyundai.mp4","Researcher.mp4","Walrus.mp4","GeicoMeteor.mp4","sw-trailor.mp4","geicoHumpDay.mp4","GeicoPig.mp4","GeicoSpy.mp4","CleaningCrew.mp4","Geico2.mp4","Geico4.mp4","Geico5.mp4","GeicoSoapOpera.mp4"]
        let random = show[Int(arc4random_uniform(UInt32(show.count)))]
        url = NSURL(string: "http://www.nielsenonlinesupport.com/colin/sdk3/assets/\(random)")
        
        return random
    }
    
    func setDtvrUrl() -> String {
        
        //Loading DTVR URL
        let c = "NielsenScienceBehindWhatsNext/prog_index.m3u8"
        url = NSURL(string: "http://www.nielseninternet.com/VOD/NielsenScienceBehindWhatsNext/prog_index.m3u8")
        
        return c
    }
    
    func loadChannelInfo() -> [String : Any] {
        
        //Loading Channel Info.
        
        let strUrl : String = (url?.absoluteString)!
        
        let channel = [ "channelName" : "ChannelTitle",
                        "mediaURL" : strUrl] as [String : Any]
        
        return channel
    }
    
    
    
    func loadContent() -> [String : Any] {
        
        //Loading Content data
        
//        url = NSURL(string: "http://www.nielseninternet.com/NielsenConsumer/prog_index.m3u8")
        let AssetIDNumber = Int.random(in: 0 ... 1000)
        let content = [
            "type":"content",
            "assetid":"C77664\(AssetIDNumber)",
            "length":"3600",
            "program":"Sample Program",
            "segB":"CustomSegmentValueB",
            "segC":"segmentC",
            "title":"S2,E3",
            "section":"Late Night Shows",
            "airdate":"20180221 10:00:00",
            "isfullepisode":"y",
            "adloadtype":"2",
            "crossId1":"MV254",
            "crossId2":"HHDJJ334",
            "optout":""] as [String : Any]
        
        
        return content
        
    }
    
    func loadContent2() -> [String : Any] {
        
        //Loading Content data
        
        //        url = NSURL(string: "http://www.nielseninternet.com/NielsenConsumer/prog_index.m3u8")
        
        let content2 = [
            "type":"content",
            "assetid":"C88664",
            "length":"3600",
            "program":"Example Video",
            "segB":"CustomSegmentValueB",
            "segC":"segmentC",
            "title":"S3,E3",
            "section":"Elephants Dream",
            "airdate":"20180221 11:00:00",
            "isfullepisode":"y",
            "adloadtype":"2",
            "crossId1":"MV222",
            "crossId2":"HHD99334",
            "optout":""] as [String : Any]
        
        
        return content2
        
    }
    
    func loadPreRollAd() -> [String : Any] {
        
        //loading Ad data.
        // URL below is what will play after the preroll Ad
        
//        url = NSURL(string: "http://www.nielseninternet.com/NWCC-3002/prog_index.m3u8")
          url = NSURL(string: "https://www.nielsenonlinesupport.com/colin/sdk3/assets/dream.mp4")

        let AdNumber = Int.random(in: 0 ... 1000)
        
        let ad = [
            "type":"preroll",
            "assetid":"AD1\(AdNumber)",
            "title":"The Best of Geico"] as [String : Any]
        
        return ad
        
    }
    
    func loadDtvr() -> [String : Any] {
        
        //Loading DTVR data
        
        let dtvr = [
            "adModel": "1" ] as [String : Any]
        
        return dtvr
        
    }
}
