//
//  LandingVC.swift
//  StandardSDK6003Swift
//
//  Created by Abdul on 17/04/18.
//  Copyright © 2018 Abdul. All rights reserved.
//

import UIKit
import NielsenAppApi
import AppTrackingTransparency
import AdSupport

class LandingVC: UIViewController, NielsenAppApiDelegate {
    
    @IBOutlet weak var btnOnlyContent: UIButton!
    @IBOutlet weak var btnContentWithAd: UIButton!
    @IBOutlet weak var btnDtvr: UIButton!
    @IBOutlet weak var btnPrivacy: UIButton!
    @IBOutlet weak var btnsettings: UIButton!
    @IBOutlet weak var lblSDKVersion: UILabel!
    @IBOutlet weak var btnWebview: UIButton!
    @IBOutlet weak var lblATTrackingValue: UILabel!
    @IBOutlet weak var lblIDFA: UILabel!
    @IBOutlet weak var lblIOSVersion: UILabel!
    
    var nielsenApi : NielsenAppApi!
    var sdkMethods : SDKMethods!
    var data : [String : Any]!
    var ipAddress:String?
    var isOptIn : Bool = true
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.view.backgroundColor = UIColor(patternImage: UIImage(named: "new_background.jpg")!)
        
        setButtonBorderColor(button: btnOnlyContent)
        setButtonBorderColor(button: btnContentWithAd)
        setButtonBorderColor(button: btnDtvr)
        setButtonBorderColor(button: btnPrivacy)
        setButtonBorderColor(button: btnsettings)
        setButtonBorderColor(button: btnWebview)
        
        //Getting the instance of NielsenApi
        self.nielsenApi = NielsenInit.createNielsenApi(delegate: self)
        lblSDKVersion.text = "SDK Version: " + self.nielsenApi.meterVersion
        
        lblIOSVersion.text = "This device running iOS: " + UIDevice.current.systemVersion
        
        sdkMethods = SDKMethods()
        self.data = sdkMethods.loadStaticMaster()
        self.nielsenApi.loadMetadata(self.data)
        
         requestPermission()
        
        self.lblIDFA.text = ASIdentifierManager.shared().advertisingIdentifier.uuidString
        
    }
    
    
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        
        if segue.identifier == "segContent" {
            let videoController = segue.destination as? ViewController
            videoController?.videoType = Constants.onlyContent
            videoController?.totalVideos = 1
            videoController?.isOptIn = self.isOptIn
            videoController?.nielsenApi = nielsenApi
            
        }else if segue.identifier == "segContentAndAd" {
            
            let videoController = segue.destination as? ViewController
            videoController?.videoType = Constants.contentWithOneAd
            videoController?.totalVideos = 2
            videoController?.isOptIn = self.isOptIn
            videoController?.nielsenApi = nielsenApi
            
        }else if segue.identifier == "segWebView" {
            
            let videoController = segue.destination as? WebViewVC
            videoController?.nielsenApi = nielsenApi
            
        }else if segue.identifier == "segDTVR" {
            
            let videoController = segue.destination as? ViewController
            videoController?.videoType = Constants.dtvrVideo
            videoController?.totalVideos = 1
            videoController?.isOptIn = self.isOptIn
            videoController?.nielsenApi = nielsenApi
            
        }else if segue.identifier == "segPrivacy" {
            
            let videoController = segue.destination as? OptOutVC
            videoController?.nielsenApi = nielsenApi
            
        }else if segue.identifier == "segPriv" {
            
            let videoController = segue.destination as? PrivacyVC
            videoController?.nielsenApi = nielsenApi
            
        }else if segue.identifier == "segSettings" {
            
            let settingsVC = segue.destination as! SettingsVC
            settingsVC.status = self.lblATTrackingValue.text
        }
    }
    
    func requestIDFA() {
        ATTrackingManager.requestTrackingAuthorization(completionHandler: { status in
            self.updatedata(status: "Authorized", idfa: (ASIdentifierManager.shared().advertisingIdentifier.uuidString))
        })
    }
    
    func requestPermission() {
        DispatchQueue.main.asyncAfter(deadline: .now() + 1.0, execute: {
            ATTrackingManager.requestTrackingAuthorization { status in
                switch status {
                case .authorized:
                    
                    self.updatedata(status: "Authorized", idfa: (ASIdentifierManager.shared().advertisingIdentifier.uuidString))
                case .denied:
                    
                    self.updatedata(status: "Denied", idfa: "IDFA Value Not Available")
                case .notDetermined:
                    
                    self.updatedata(status: "Not Determined", idfa: (ASIdentifierManager.shared().advertisingIdentifier.uuidString))
                case .restricted:
                    
                    self.updatedata(status: "Restricted", idfa: "IDFA Value Not Available")
                @unknown default:
                    self.updatedata(status: "Unknown", idfa: "")
                }
            }
        })
    }
    
    func updatedata(status: String, idfa: String){
        DispatchQueue.main.async {
            UserDefaults.standard.set(status, forKey: "idfaStatus")
#if targetEnvironment(simulator)
            // your simulator code
            if(status == "Authorized"){
                self.lblIDFA.text = "EA7583CD-A667-48BC-B806-42ECB2B48606"
            }else{
                self.lblIDFA.text = "00000000-0000-0000-0000-000000000000"
            }
#else
            // your real device code
            self.lblIDFA.text = idfa
#endif
            
            self.lblATTrackingValue.text = status
            self.navigationController?.popViewController(animated: true)
        }
    }
    
    func setButtonBorderColor(button : UIButton){
        
        button.layer.borderColor = UIColor.white.cgColor
    }
    
}
