package com.nielsen.simplestaticandroid.activities;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.nielsen.app.sdk.AppSdk;
import com.nielsen.app.sdk.IAppNotifier;
import com.nielsen.simplestaticandroid.R;
import com.nielsen.simplestaticandroid.models.NielsenInit;
import com.nielsen.simplestaticandroid.models.SDKMethods;

import org.json.JSONObject;

public class LandingActivity extends AppCompatActivity implements IAppNotifier, View.OnClickListener {

    private final String TAG = LandingActivity.class.getSimpleName();

    TextView txtSectionA, txtSectionB, txtVersion;

    public static AppSdk appSdkMain;

    JSONObject data = null;
    SDKMethods sdkMethods;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_landing);

        //Mark: In NielsenInit class we are initialising the NielsenSDK.
        //Getting the instance of NielsenSDK.
        NielsenInit nielsenInit = new NielsenInit();

        //2nd parameter "this" referes to IAppNotifier interface which is needed to initialise NielsenSDK.
        appSdkMain = nielsenInit.initAppSdk(getApplicationContext(), this);

        initUI();

        //Mark: In SDKMethods class we wrote methods which creates content,Ad,DTVR objects,urls
        sdkMethods = new SDKMethods();

    }

    private void initUI(){
        txtVersion = findViewById(R.id.txtVersion);
        txtSectionA = findViewById(R.id.txtSectionA);
        txtSectionB = findViewById(R.id.txtSectionB);

        txtVersion.setText(getResources().getString(R.string.sdk_version) + " " + appSdkMain.getMeterVersion());

        txtSectionA.setOnClickListener(this);
        txtSectionB.setOnClickListener(this);
    }

    @Override
    protected void onResume() {
        super.onResume();

        data = sdkMethods.loadStaticMaster();
        appSdkMain.loadMetadata(data);
        Log.i(TAG, "Fired Main Static Event");
    }

    @Override
    public void onClick(View v) {

        switch (v.getId()){

            case R.id.txtSectionA:

                Intent intentSecA = new Intent(LandingActivity.this, SectionAActivity.class);
                startActivity(intentSecA);

                break;

            case R.id.txtSectionB:
                Intent intentSecB = new Intent(LandingActivity.this, SectionBActivity.class);
                startActivity(intentSecB);

                break;
        }

    }

    @Override
    public void onAppSdkEvent(long l, int i, String s) {

    }
}
