package com.nielsen.simplestandardandroid8200.activities;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CompoundButton;
import android.widget.Spinner;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.SwitchCompat;

import com.nielsen.simplestandardandroid8200.R;
import com.nielsen.simplestandardandroid8200.utils.Constants;

public class PrivacyActivity extends AppCompatActivity implements CompoundButton.OnCheckedChangeListener {

    Spinner spCountry, spLanguage;
    SwitchCompat switchOptOut;
    String selectedCountry = "", selectedLang = "", priv_url = "";

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_privacy);

        initUI();
        setCountrySpinner();
        setLanguageSpinner();
        setUrl();
    }

    private void initUI() {
        spCountry = (Spinner) findViewById(R.id.sp_country);
        spLanguage = (Spinner) findViewById(R.id.sp_language);
        switchOptOut = (SwitchCompat) findViewById(R.id.switchOptOut);
        TextView txtLaunch = (TextView) findViewById(R.id.txtLaunch);

        switchOptOut.setOnCheckedChangeListener(this);

        txtLaunch.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(PrivacyActivity.this, OptOutActivity.class)
                        .putExtra(Constants.INTENT_OPTOUT_URL, priv_url));
            }
        });
    }

    private void setCountrySpinner(){
        ArrayAdapter<CharSequence> adapter = ArrayAdapter.createFromResource(this,
                R.array.country_array, android.R.layout.simple_spinner_item);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spCountry.setAdapter(adapter);

        spCountry.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parentView, View selectedItemView, int position, long id) {
                selectedCountry = Constants.strCountryArray[position];
                setUrl();
            }

            @Override
            public void onNothingSelected(AdapterView<?> parentView) {
            }

        });
    }

    private void setLanguageSpinner(){
        ArrayAdapter<CharSequence> adapter = ArrayAdapter.createFromResource(this,
                R.array.language_array, android.R.layout.simple_spinner_item);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spLanguage.setAdapter(adapter);

        spLanguage.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parentView, View selectedItemView, int position, long id) {
                selectedLang = Constants.strLanguageArray[position];
                setUrl();
            }

            @Override
            public void onNothingSelected(AdapterView<?> parentView) {
            }

        });
    }

    private void setUrl(){
        if(switchOptOut.isChecked()){

            priv_url = "https://priv-policy.imrworldwide.com/priv/mobile/" + selectedCountry + "/" + selectedLang + "/optout_legacy.html";

        }else{
            priv_url = "https://priv-policy.imrworldwide.com/priv/mobile/" + selectedCountry + "/" + selectedLang + "/optout.html";
        }
    }

    @Override
    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        if(switchOptOut.isChecked()){
            switchOptOut.setText("Load OptOut Legacy URL");

        }else{
            switchOptOut.setText("Load normal OptOut URL");

        }
        setUrl();
    }
}
