/*
 * Decompiled with CFR 0.152.
 */
package com.nielsen.app.sdk;

import android.content.Context;
import com.nielsen.app.sdk.AppBgFgTransitionNotifier;
import com.nielsen.app.sdk.AppLaunchMeasurementManager;
import com.nielsen.app.sdk.IAppNotifier;
import com.nielsen.app.sdk.a;
import com.nielsen.app.sdk.bk;
import com.nielsen.app.sdk.c;
import com.nielsen.app.sdk.v;
import com.nielsen.app.sdk.y;
import java.io.Closeable;
import org.json.JSONObject;

class AppSdkBase
implements Closeable {
    public static final int ERROR_FAILED_CREATE_URL_STRING = 1001;
    public static final int ERROR_FAILED_RECEIVE_CONFIG = 1002;
    public static final int ERROR_FAILED_PARSING_CONFIG = 1003;
    public static final int ERROR_FAILED_PARSING_PLAY = 1004;
    public static final int ERROR_FAILED_PARSING_METADATA = 1005;
    public static final int ERROR_FAILED_GENERATING_PING = 1006;
    public static final int ERROR_FAILED_PROCESSOR_START = 1007;
    public static final int ERROR_FAILED_PROCESS_ID3 = 1008;
    public static final int ERROR_FAILED_HTTP_SEND = 1009;
    public static final int ERROR_FAILED_SENDING_PING = 1010;
    public static final int ERROR_FAILED_SENDING_TSV = 1011;
    public static final int ERROR_FAILED_SENDING_STATION_ID = 1012;
    public static final int ERROR_FAILED_ACCESSING_DB = 1013;
    public static final int ERROR_CHANGED_DEVICE_ID = 1014;
    public static final int ERROR_CHANGED_NUID = 1015;
    public static final int ERROR_SDK_NOT_INITIALIZED = 1016;
    public static final int ERROR_FAILED_SDK_SUSPEND = 1017;
    public static final int ERROR_INVALID_PARAMETERS = 1018;
    public static final int ERROR_INVALID_STATE = 1019;
    public static final int ERROR_FAILED_PROCESS_PLAYHEAD = 1020;
    public static final int ERROR_FAILED_PROCESS_METADATA = 1021;
    public static final int ERROR_FAILED_PROCESS_STOP = 1022;
    public static final int EVENT_INITIATE = 2000;
    public static final int EVENT_STARTUP = 2001;
    public static final int EVENT_SHUTDOWN = 2002;
    private boolean mNielsenEventTrackerUsed;
    private Context mContext = null;
    private static AppBgFgTransitionNotifier mAppBgFgTransitionNotifier;
    private static y mAppNetworkStateMonitor;
    private a mAppApi = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Deprecated
    public AppSdkBase(Context context, String appInfo, IAppNotifier notifier, boolean trackEventEnabled) {
        boolean bl2 = false;
        try {
            this.mNielsenEventTrackerUsed = trackEventEnabled;
            if (trackEventEnabled && appInfo != null) {
                JSONObject jSONObject = new JSONObject(appInfo);
                jSONObject.put("sdkapitype", (Object)"t");
                appInfo = jSONObject.toString();
            }
            this.logMessage('D', "Nielsen AppSDK: constructor API - %s ", (bl2 = this.initialize(context, appInfo, notifier)) ? "SUCCESS" : "FAILED");
        }
        catch (Exception exception) {
            this.logMessage('E', "Nielsen AppSDK: constructor API - EXCEPTION : %s ", exception.getMessage());
            this.logMessage('D', "Nielsen AppSDK: constructor API - %s ", bl2 ? "SUCCESS" : "FAILED");
        }
        catch (Error error) {
            this.logMessage('E', "Nielsen AppSDK: constructor API - ERROR : %s ", error.getMessage());
            this.logMessage('D', "Nielsen AppSDK: constructor API - %s ", bl2 ? "SUCCESS" : "FAILED");
            {
                catch (Throwable throwable) {
                    this.logMessage('D', "Nielsen AppSDK: constructor API - %s ", bl2 ? "SUCCESS" : "FAILED");
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public AppSdkBase(Context context, JSONObject appInfo, IAppNotifier notifier, boolean trackEventEnabled) {
        boolean bl2 = false;
        try {
            if (trackEventEnabled && appInfo != null) {
                appInfo.put("sdkapitype", (Object)"t");
            }
            String string = null;
            if (appInfo != null && appInfo.length() > 0) {
                string = appInfo.toString();
            }
            this.logMessage('D', "Nielsen AppSDK: constructor API - %s ", (bl2 = this.initialize(context, string, notifier)) ? "SUCCESS" : "FAILED");
        }
        catch (Exception exception) {
            this.logMessage('E', "Nielsen AppSDK: constructor API - EXCEPTION : %s ", exception.getMessage());
            this.logMessage('D', "Nielsen AppSDK: constructor API - %s ", bl2 ? "SUCCESS" : "FAILED");
        }
        catch (Error error) {
            this.logMessage('E', "Nielsen AppSDK: constructor API - ERROR : %s ", error.getMessage());
            this.logMessage('D', "Nielsen AppSDK: constructor API - %s ", bl2 ? "SUCCESS" : "FAILED");
            {
                catch (Throwable throwable) {
                    this.logMessage('D', "Nielsen AppSDK: constructor API - %s ", bl2 ? "SUCCESS" : "FAILED");
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean initialize(Context context, String appInfo, IAppNotifier notifier) {
        boolean bl2 = false;
        try {
            if (appInfo != null && !appInfo.isEmpty() && context != null) {
                this.mContext = context.getApplicationContext();
                this.mAppApi = new a(context, appInfo, null, notifier);
                this.logMessage('I', "Nielsen AppSDK appInit: %s ", appInfo);
                if (!this.mAppApi.e()) {
                    if (this.mAppApi.b('E')) {
                        v.b('E', "Nielsen AppSDK: constructor API - FAILED; initialization failed", new Object[0]);
                    }
                } else {
                    AppSdkBase.registerLifeCycleObserver(this.mContext);
                    mAppNetworkStateMonitor = y.a();
                    if (mAppNetworkStateMonitor.b()) {
                        this.logMessage('D', "AppNetworkStateMonitor: Network connection available. Network type - %s", mAppNetworkStateMonitor.d());
                    } else {
                        this.logMessage('D', "AppNetworkStateMonitor: Network connection not available!");
                    }
                    bl2 = true;
                }
            }
        }
        finally {
            if (bl2) {
                if (this.mAppApi != null) {
                    if (this.mAppApi.v() != null) {
                        this.mAppApi.v().a(0, "App SDK was successfully initiated", new Object[0]);
                    }
                    if (this.mAppApi.u() != null) {
                        this.mAppApi.u().a(0, "App SDK was successfully initiated");
                    }
                }
            } else {
                this.close();
            }
        }
        return bl2;
    }

    a getAppApi() {
        return this.mAppApi;
    }

    public static void registerLifeCycleObserver(Context applicationContext) {
        if (applicationContext != null) {
            if (mAppBgFgTransitionNotifier == null) {
                try {
                    mAppBgFgTransitionNotifier = AppBgFgTransitionNotifier.a();
                    mAppBgFgTransitionNotifier.a(applicationContext.getApplicationContext());
                }
                catch (Exception exception) {
                    v.b('W', "AndroidX LifecycleObserver can not be observed. Please use androidx dependency to activate SDK auto-detection of app background/foreground state.", new Object[0]);
                }
                catch (Error error) {
                    v.b('W', "AndroidX LifecycleObserver can not be observed. Please use androidx dependency to activate SDK auto-detection of app background/foreground state.", new Object[0]);
                }
            } else {
                v.b('I', "LifeCycleObserver is already registered", new Object[0]);
            }
        } else {
            v.b('W', "Failed to register the LifeCycleObserver as the application context object is invalid", new Object[0]);
        }
    }

    public void setDebugLevel(char debugState) {
        if (this.mAppApi != null) {
            this.mAppApi.a(debugState);
        }
    }

    @Deprecated
    public static void setDebug(char debugState) {
        v.b('W', "AppSdk's static method setDebug() is deprecated now. Instead use instance method setDebugLevel()", new Object[0]);
    }

    boolean isDevDebugOn(char logLevel) {
        if (this.mAppApi != null) {
            return this.mAppApi.b(logLevel);
        }
        return false;
    }

    @Override
    public void close() {
        if (this.mAppApi != null) {
            try {
                this.mAppApi.d();
                this.mAppApi = null;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                this.logMessage('I', "IllegalThreadStateException occurred while starting sdk close thread. %s", illegalThreadStateException.getLocalizedMessage());
            }
            catch (Exception exception) {
                this.logMessage('I', "Exception occurred while starting sdk close thread. %s ", exception.getLocalizedMessage());
            }
        }
    }

    public void suspend() {
        String string;
        boolean bl2 = false;
        try {
            if (this.mAppApi == null) {
                v.b('E', "suspend API - Failed initialization", new Object[0]);
            } else {
                bl2 = this.mAppApi.g();
                if (!bl2) {
                    this.mAppApi = null;
                }
            }
            string = bl2 ? "BACKGROUND" : "TERMINATED";
        }
        catch (Exception exception) {
            String string2;
            try {
                this.logMessage('E', "suspend API - EXCEPTION : %s ", exception.getMessage());
                string2 = bl2 ? "BACKGROUND" : "TERMINATED";
            }
            catch (Throwable throwable) {
                String string3 = bl2 ? "BACKGROUND" : "TERMINATED";
                this.logMessage('I', "suspend API. %s", string3);
                throw throwable;
            }
            this.logMessage('I', "suspend API. %s", string2);
        }
        this.logMessage('I', "suspend API. %s", string);
    }

    public boolean isValid() {
        boolean bl2 = true;
        if (this.mAppApi == null) {
            bl2 = false;
        } else {
            this.mAppApi.f().a("isValid");
            this.logMessage('D', "isValid API - %s ", bl2 ? "TRUE" : "FALSE");
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    void loadMetadata(String jsonMetadata) {
        String string;
        boolean bl2 = false;
        try {
            if (this.mAppApi.f() != null && !this.mNielsenEventTrackerUsed) {
                this.mAppApi.f().a("loadMetadata", jsonMetadata);
            }
            string = (bl2 = this.mAppApi.g(jsonMetadata)) ? "SUCCESS" : "FAILED";
        }
        catch (Exception exception) {
            String string2;
            try {
                this.logMessage('E', "Nielsen AppSDK: loadMetadata API - EXCEPTION : %s ", exception.getMessage());
                string2 = bl2 ? "SUCCESS" : "FAILED";
            }
            catch (Throwable throwable) {
                String string3 = bl2 ? "SUCCESS" : "FAILED";
                this.logMessage('I', "Nielsen AppSDK: loadMetadata API. %s", string3);
                throw throwable;
            }
            this.logMessage('I', "Nielsen AppSDK: loadMetadata API. %s", string2);
        }
        this.logMessage('I', "Nielsen AppSDK: loadMetadata API. %s", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadMetadata(JSONObject jsonMetadata) {
        String string;
        boolean bl2 = false;
        try {
            string = null;
            if (jsonMetadata != null && jsonMetadata.length() > 0) {
                string = jsonMetadata.toString();
            }
            if (this.mAppApi.f() != null && !this.mNielsenEventTrackerUsed) {
                this.mAppApi.f().a("loadMetadata", string);
            }
            string = (bl2 = this.mAppApi.g(string)) ? "SUCCESS" : "FAILED";
        }
        catch (Exception exception) {
            String string2;
            try {
                this.logMessage('E', "loadMetadata API - EXCEPTION : %s ", exception.getMessage());
                string2 = bl2 ? "SUCCESS" : "FAILED";
            }
            catch (Throwable throwable) {
                String string3 = bl2 ? "SUCCESS" : "FAILED";
                this.logMessage('I', "loadMetadata API - %s ", string3);
                throw throwable;
            }
            this.logMessage('I', "loadMetadata API - %s ", string2);
        }
        this.logMessage('I', "loadMetadata API - %s ", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPlayheadPosition(long position) {
        String string;
        boolean bl2;
        block6: {
            bl2 = false;
            if (this.mAppApi != null) break block6;
            v.b('E', "setPlayheadPosition API - Failed initialization", new Object[0]);
            String string2 = bl2 ? "SUCCESS" : "FAILED";
            this.logMessage('I', "setPlayheadPosition API. %s", string2);
            return;
        }
        try {
            if (this.mAppApi.f() != null && !this.mNielsenEventTrackerUsed) {
                this.mAppApi.f().a("setPlayheadPosition", position);
            }
            string = (bl2 = this.mAppApi.b(position)) ? "SUCCESS" : "FAILED";
        }
        catch (Exception exception) {
            String string3;
            try {
                this.logMessage('E', "setPlayheadPosition API - EXCEPTION : %s ", exception.getMessage());
                string3 = bl2 ? "SUCCESS" : "FAILED";
            }
            catch (Throwable throwable) {
                String string4 = bl2 ? "SUCCESS" : "FAILED";
                this.logMessage('I', "setPlayheadPosition API. %s", string4);
                throw throwable;
            }
            this.logMessage('I', "setPlayheadPosition API. %s", string3);
        }
        this.logMessage('I', "setPlayheadPosition API. %s", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendID3(String payload) {
        String string;
        boolean bl2 = false;
        try {
            boolean bl3 = payload == null || payload.isEmpty();
            this.logMessage('I', "sendId3  ID3 tag %s ", bl3 ? "EMPTY" : payload);
            if (this.mAppApi == null) {
                v.b('E', "sendID3 API - Failed initialization", new Object[0]);
            } else if (bl3) {
                this.mAppApi.a(8, 'E', "sendID3 API - FAILED; ID3 tag empty or null", new Object[0]);
            } else {
                if (this.mAppApi.f() != null && !this.mNielsenEventTrackerUsed) {
                    this.mAppApi.f().a("sendID3", payload);
                }
                bl2 = this.mAppApi.b(payload);
            }
            string = bl2 ? "SUCCESS" : "FAILED";
        }
        catch (Exception exception) {
            String string2;
            try {
                this.logMessage('E', "sendID3 API - EXCEPTION : %s ", exception.getMessage());
                string2 = bl2 ? "SUCCESS" : "FAILED";
            }
            catch (Throwable throwable) {
                String string3 = bl2 ? "SUCCESS" : "FAILED";
                this.logMessage('I', "sendID3 API. %s", string3);
                throw throwable;
            }
            this.logMessage('I', "sendID3 API. %s", string2);
        }
        this.logMessage('I', "sendID3 API. %s", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    void play(String channelInfo) {
        String string;
        boolean bl2 = false;
        try {
            if (this.mAppApi.f() != null && !this.mNielsenEventTrackerUsed) {
                this.mAppApi.f().a("play", channelInfo);
            }
            string = (bl2 = this.mAppApi.f(channelInfo)) ? "SUCCESS" : "FAILED";
        }
        catch (Exception exception) {
            String string2;
            try {
                this.logMessage('E', "Nielsen AppSDK: play API - EXCEPTION : %s ", exception.getMessage());
                string2 = bl2 ? "SUCCESS" : "FAILED";
            }
            catch (Throwable throwable) {
                String string3 = bl2 ? "SUCCESS" : "FAILED";
                this.logMessage('I', "Nielsen AppSDK: play API. %s", string3);
                throw throwable;
            }
            this.logMessage('I', "Nielsen AppSDK: play API. %s", string2);
        }
        this.logMessage('I', "Nielsen AppSDK: play API. %s", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void play(JSONObject channelInfo) {
        String string;
        boolean bl2 = false;
        try {
            string = null;
            if (channelInfo != null && channelInfo.length() > 0) {
                string = channelInfo.toString();
            }
            if (this.mAppApi.f() != null && !this.mNielsenEventTrackerUsed) {
                this.mAppApi.f().a("play", string);
            }
            string = (bl2 = this.mAppApi.f(string)) ? "SUCCESS" : "FAILED";
        }
        catch (Exception exception) {
            String string2;
            try {
                this.logMessage('E', "Nielsen AppSDK: play API - EXCEPTION : %s ", exception.getMessage());
                string2 = bl2 ? "SUCCESS" : "FAILED";
            }
            catch (Throwable throwable) {
                String string3 = bl2 ? "SUCCESS" : "FAILED";
                this.logMessage('I', "Nielsen AppSDK: play API - %s ", string3);
                throw throwable;
            }
            this.logMessage('I', "Nielsen AppSDK: play API - %s ", string2);
        }
        this.logMessage('I', "Nielsen AppSDK: play API - %s ", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        if (this.mAppApi != null) {
            this.mAppApi.a('I', "stop", new Object[0]);
            if (this.mAppApi.f() != null && !this.mNielsenEventTrackerUsed) {
                this.mAppApi.f().a("stop");
            }
        }
        AppSdkBase appSdkBase = null;
        boolean bl2 = false;
        try {
            Object object;
            if (this.mAppApi == null) {
                v.b('E', "stop API - Failed initialization", new Object[0]);
            } else {
                object = this.mAppApi.i();
                if (object != null) {
                    boolean bl3 = (Boolean)object.first;
                    bl2 = (Boolean)object.second;
                    if (bl3) {
                        if (bl2) {
                            this.mAppApi = null;
                        }
                        appSdkBase = this;
                    }
                }
            }
            object = (appSdkBase == null ? "FAILED" : "SUCCESS") + (bl2 ? " - KILLED" : "");
            this.logMessage('I', "stop API. %s", (String)object);
        }
        catch (Exception exception) {
            try {
                this.logMessage('E', "stop API - EXCEPTION : %s ", exception.getMessage());
                String string = (appSdkBase == null ? "FAILED" : "SUCCESS") + (bl2 ? " - KILLED" : "");
                this.logMessage('I', "stop API. %s", string);
            }
            catch (Throwable throwable) {
                String string = (appSdkBase == null ? "FAILED" : "SUCCESS") + (bl2 ? " - KILLED" : "");
                this.logMessage('I', "stop API. %s", string);
                throw throwable;
            }
        }
    }

    public void end() {
        String string;
        boolean bl2 = false;
        try {
            if (this.mAppApi == null) {
                v.b('E', "end API - Failed initialization", new Object[0]);
            } else {
                if (this.mAppApi.f() != null && !this.mNielsenEventTrackerUsed) {
                    this.mAppApi.f().a("end");
                }
                bl2 = this.mAppApi.j();
            }
            string = bl2 ? "SUCCESS" : "FAILED";
        }
        catch (Exception exception) {
            String string2;
            try {
                this.logMessage('E', "end API - EXCEPTION : %s ", exception.getMessage());
                string2 = bl2 ? "SUCCESS" : "FAILED";
            }
            catch (Throwable throwable) {
                String string3 = bl2 ? "SUCCESS" : "FAILED";
                this.logMessage('I', "end API. %s", string3);
                throw throwable;
            }
            this.logMessage('I', "end API. %s", string2);
        }
        this.logMessage('I', "end API. %s", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appDisableApi(boolean disabled) {
        String string;
        boolean bl2 = false;
        try {
            this.logMessage('I', "appDisableApi %s ", disabled ? "TRUE" : "FALSE");
            if (this.mAppApi == null) {
                v.b('E', "appDisableApi API - Failed initialization", new Object[0]);
            } else {
                bl2 = this.mAppApi.b(disabled);
            }
            string = bl2 ? "SUCCESS" : "FAILED";
        }
        catch (Exception exception) {
            String string2;
            try {
                this.logMessage('E', "appDisableApi API - EXCEPTION : %s ", exception.getMessage());
                string2 = bl2 ? "SUCCESS" : "FAILED";
            }
            catch (Throwable throwable) {
                String string3 = bl2 ? "SUCCESS" : "FAILED";
                this.logMessage('I', "appDisableApi API. %s", string3);
                throw throwable;
            }
            this.logMessage('I', "appDisableApi API. %s", string2);
        }
        this.logMessage('I', "appDisableApi API. %s", string);
    }

    public boolean getAppDisable() {
        String string;
        if (this.mAppApi != null) {
            this.mAppApi.f().a("getAppDisable");
        }
        boolean bl2 = false;
        try {
            if (this.mAppApi == null) {
                v.b('E', "getAppDisable API - Failed initialization", new Object[0]);
            } else {
                bl2 = this.mAppApi.s();
            }
            string = bl2 ? "FAILED" : "SUCCESS";
        }
        catch (Exception exception) {
            String string2;
            try {
                this.logMessage('E', "getAppDisable API - EXCEPTION : %s ", exception.getMessage());
                string2 = bl2 ? "FAILED" : "SUCCESS";
            }
            catch (Throwable throwable) {
                String string3 = bl2 ? "FAILED" : "SUCCESS";
                this.logMessage('I', "getAppDisable API. %s", string3);
                throw throwable;
            }
            this.logMessage('I', "getAppDisable API. %s", string2);
        }
        this.logMessage('I', "getAppDisable API. %s", string);
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean userOptOut(String optOut) {
        String string;
        boolean bl2 = false;
        try {
            boolean bl3 = optOut == null || optOut.isEmpty();
            this.logMessage('I', "optOutURLString %s ", bl3 ? "NONE" : optOut);
            if (this.mAppApi == null) {
                v.b('E', "userOptOut API - Failed initialization", new Object[0]);
            } else if (bl3) {
                this.mAppApi.a(18, 'E', "userOptOut API - FAILED; empty or null parameter", new Object[0]);
            } else {
                if (this.mAppApi.f() != null && !this.mNielsenEventTrackerUsed) {
                    this.mAppApi.f().a("userOptOut", optOut);
                }
                bl2 = this.mAppApi.d(optOut);
            }
            string = bl2 ? "SUCCESS" : "FAILED";
        }
        catch (Exception exception) {
            String string2;
            try {
                this.logMessage('E', "userOptOut API - EXCEPTION : %s ", exception.getMessage());
                string2 = bl2 ? "SUCCESS" : "FAILED";
            }
            catch (Throwable throwable) {
                String string3 = bl2 ? "SUCCESS" : "FAILED";
                this.logMessage('I', "userOptOut API. %s", string3);
                throw throwable;
            }
            this.logMessage('I', "userOptOut API. %s", string2);
        }
        this.logMessage('I', "userOptOut API. %s", string);
        return bl2;
    }

    public String userOptOutURLString() {
        String string = "";
        try {
            if (this.mAppApi == null) {
                v.b('E', "userOptOutURLString API - Failed initialization", new Object[0]);
            } else {
                string = this.mAppApi.r();
                this.mAppApi.a('I', "userOptOut %s ", string);
            }
            this.logMessage('I', "userOptOutURLString API. URL(%s)", string);
            this.logMessage('D', "userOptOutURLString API - %s ", (string != null && !string.isEmpty() ? "SUCCESS; " : "FAILED; ") + string);
        }
        catch (Exception exception) {
            try {
                this.logMessage('E', "userOptOutURLString API - EXCEPTION : %s ", exception.getMessage());
                this.logMessage('I', "userOptOutURLString API. URL(%s)", string);
                this.logMessage('D', "userOptOutURLString API - %s ", (string != null && !string.isEmpty() ? "SUCCESS; " : "FAILED; ") + string);
            }
            catch (Throwable throwable) {
                this.logMessage('I', "userOptOutURLString API. URL(%s)", string);
                this.logMessage('D', "userOptOutURLString API - %s ", (string != null && !string.isEmpty() ? "SUCCESS; " : "FAILED; ") + string);
                throw throwable;
            }
        }
        return string;
    }

    public boolean getOptOutStatus() {
        boolean bl2 = false;
        if (this.mAppApi != null) {
            this.mAppApi.f().a("getOptOutStatus");
            bl2 = this.mAppApi.I();
        }
        return bl2;
    }

    public String getNielsenId() {
        if (this.mAppApi != null) {
            this.mAppApi.f().a("getNielsenId");
        }
        String string = "";
        try {
            if (this.mAppApi == null) {
                v.b('E', "getNielsenId API - Failed initialization", new Object[0]);
            } else {
                string = this.mAppApi.o();
            }
            this.logMessage('I', "getNielsenId API. NUID(%s)", string);
            this.logMessage('D', "getNielsenId API - %s ", string != null ? "SUCCESS" : "FAILED");
        }
        catch (Exception exception) {
            try {
                this.logMessage('E', "getNielsenId API - EXCEPTION : %s ", exception.getMessage());
                this.logMessage('I', "getNielsenId API. NUID(%s)", string);
                this.logMessage('D', "getNielsenId API - %s ", string != null ? "SUCCESS" : "FAILED");
            }
            catch (Throwable throwable) {
                this.logMessage('I', "getNielsenId API. NUID(%s)", string);
                this.logMessage('D', "getNielsenId API - %s ", string != null ? "SUCCESS" : "FAILED");
                throw throwable;
            }
        }
        return string;
    }

    public String getDeviceId() {
        if (this.mAppApi != null) {
            this.mAppApi.f().a("getDeviceId");
        }
        String string = "";
        try {
            if (this.mAppApi == null) {
                v.b('E', "getDeviceId API - Failed initialization", new Object[0]);
            } else {
                string = this.mAppApi.o();
            }
            this.logMessage('I', "getDeviceId API. DeviceId(%s)", string);
            this.logMessage('D', "getDeviceId API - %s ", string != null ? "SUCCESS" : "FAILED");
        }
        catch (Exception exception) {
            try {
                this.logMessage('E', "getDeviceId API - EXCEPTION : %s ", exception.getMessage());
                this.logMessage('I', "getDeviceId API. DeviceId(%s)", string);
                this.logMessage('D', "getDeviceId API - %s ", string != null ? "SUCCESS" : "FAILED");
            }
            catch (Throwable throwable) {
                this.logMessage('I', "getDeviceId API. DeviceId(%s)", string);
                this.logMessage('D', "getDeviceId API - %s ", string != null ? "SUCCESS" : "FAILED");
                throw throwable;
            }
        }
        return string;
    }

    public String getVendorId() {
        String string = "";
        try {
            if (this.mAppApi == null) {
                v.b('E', "getVendorId API - Failed initialization", new Object[0]);
            } else {
                string = this.mAppApi.q();
            }
            this.logMessage('I', "getVendorId API. VendorId(%s)", string);
            this.logMessage('D', "getVendorId API - %s ", !string.isEmpty() ? "SUCCESS" : "FAILED");
        }
        catch (Exception exception) {
            try {
                this.logMessage('E', "getVendorId API - EXCEPTION : %s ", exception.getMessage());
                this.logMessage('I', "getVendorId API. VendorId(%s)", string);
                this.logMessage('D', "getVendorId API - %s ", !string.isEmpty() ? "SUCCESS" : "FAILED");
            }
            catch (Throwable throwable) {
                this.logMessage('I', "getVendorId API. VendorId(%s)", string);
                this.logMessage('D', "getVendorId API - %s ", !string.isEmpty() ? "SUCCESS" : "FAILED");
                throw throwable;
            }
        }
        return string;
    }

    public static String getMeterVersion() {
        String string = a.n();
        v.b('D', "getMeterVersion API - " + (string != null && !string.isEmpty() ? string : "NONE"), new Object[0]);
        return string;
    }

    public String getLastEvent() {
        String string;
        String string2 = "";
        try {
            if (this.mAppApi == null) {
                v.b('E', "getLastEvent API - Failed initialization", new Object[0]);
            } else {
                string2 = this.mAppApi.l();
            }
            string = string2 != null && !string2.isEmpty() ? string2 : "NONE";
        }
        catch (Exception exception) {
            String string3;
            try {
                this.logMessage('E', "getLastEvent API - EXCEPTION : %s ", exception.getMessage());
                string3 = string2 != null && !string2.isEmpty() ? string2 : "NONE";
            }
            catch (Throwable throwable) {
                String string4 = string2 != null && !string2.isEmpty() ? string2 : "NONE";
                this.logMessage('I', "getLastEvent API. Event(%s)", string4);
                throw throwable;
            }
            this.logMessage('I', "getLastEvent API. Event(%s)", string3);
        }
        this.logMessage('I', "getLastEvent API. Event(%s)", string);
        return string2;
    }

    public String getLastError() {
        String string;
        String string2 = "";
        try {
            if (this.mAppApi == null) {
                v.b('E', "getLastError API - Failed initialization", new Object[0]);
            } else {
                string2 = this.mAppApi.m();
            }
            string = string2 != null && !string2.isEmpty() ? string2 : "NONE";
        }
        catch (Exception exception) {
            String string3;
            try {
                this.logMessage('E', "getLastError API - EXCEPTION : %s ", exception.getMessage());
                string3 = string2 != null && !string2.isEmpty() ? string2 : "NONE";
            }
            catch (Throwable throwable) {
                String string4 = string2 != null && !string2.isEmpty() ? string2 : "NONE";
                this.logMessage('I', "getLastError API. Error(%s)", string4);
                throw throwable;
            }
            this.logMessage('I', "getLastError API. Error(%s)", string3);
        }
        this.logMessage('I', "getLastError API. Error(%s)", string);
        return string2;
    }

    public void appInForeground(Context context) {
        if (this.mAppApi != null) {
            this.mAppApi.f().a("appInForeground");
        }
        this.logMessage('I', "appInForeground API - Started", "");
        AppLaunchMeasurementManager.appInForeground(context);
        this.logMessage('I', "appInForeground API - Ended", "");
    }

    public void appInBackground(Context context) {
        if (this.mAppApi != null) {
            this.mAppApi.f().a("appInBackground");
        }
        this.logMessage('I', "appInBackground API - Started", "");
        AppLaunchMeasurementManager.appInBackground(context);
        this.logMessage('I', "appInBackground API - Ended", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateOTT(JSONObject ottInfo) {
        String string;
        boolean bl2 = false;
        try {
            if (this.mAppApi == null) {
                v.b('E', "updateOTT API - Failed initialization", new Object[0]);
            } else {
                string = null;
                if (ottInfo != null && ottInfo.length() > 0) {
                    string = ottInfo.toString();
                }
                if (this.mAppApi.f() != null && !this.mNielsenEventTrackerUsed) {
                    this.mAppApi.f().a("updateOTT", string);
                }
                bl2 = this.mAppApi.e(string);
            }
            string = bl2 ? "SUCCESS" : "FAILED";
        }
        catch (Exception exception) {
            String string2;
            try {
                this.logMessage('E', "updateOTT API - EXCEPTION : %s ", exception.getMessage());
                string2 = bl2 ? "SUCCESS" : "FAILED";
            }
            catch (Throwable throwable) {
                String string3 = bl2 ? "SUCCESS" : "FAILED";
                this.logMessage('I', "updateOTT API. %s", string3);
                throw throwable;
            }
            this.logMessage('I', "updateOTT API. %s", string2);
        }
        this.logMessage('I', "updateOTT API. %s", string);
    }

    public String getDemographicId() {
        if (this.mAppApi != null) {
            this.mAppApi.f().a("getDemographicId");
        }
        String string = "";
        try {
            if (this.mAppApi == null) {
                v.b('E', "getDemographicId API - Failed initialization", new Object[0]);
            } else {
                bk bk2 = this.mAppApi.w();
                if (bk2 != null) {
                    string = bk2.h();
                }
            }
            this.logMessage('I', "getDemographicId API. DemographicId(%s)", string);
            this.logMessage('D', "getDemographicId API - %s ", string != null && !string.isEmpty() ? "SUCCESS" : "FAILED");
        }
        catch (Exception exception) {
            try {
                this.logMessage('E', "getDemographicId API - EXCEPTION : %s ", exception.getMessage());
                this.logMessage('I', "getDemographicId API. DemographicId(%s)", string);
                this.logMessage('D', "getDemographicId API - %s ", string != null && !string.isEmpty() ? "SUCCESS" : "FAILED");
            }
            catch (Throwable throwable) {
                this.logMessage('I', "getDemographicId API. DemographicId(%s)", string);
                this.logMessage('D', "getDemographicId API - %s ", string != null && !string.isEmpty() ? "SUCCESS" : "FAILED");
                throw throwable;
            }
        }
        return string;
    }

    c getAppCatApiLogger() {
        return this.mAppApi.f();
    }

    static AppBgFgTransitionNotifier getAppBgFgTransitionNotifier() {
        return mAppBgFgTransitionNotifier;
    }

    public String getFirstPartyId() {
        String string = "";
        try {
            if (this.mAppApi == null) {
                v.b('E', "getFirstPartyId API - Failed initialization", new Object[0]);
            } else {
                string = this.mAppApi.H();
            }
        }
        catch (Exception exception) {
            this.logMessage('E', "getFirstPartyId API - EXCEPTION : %s ", exception.getMessage());
        }
        finally {
            this.logMessage('I', "getFirstPartyId API. FirstPartyId(%s)", string);
        }
        return string;
    }

    void logMessage(char level, String format, String message) {
        if (this.mAppApi != null) {
            this.mAppApi.a(level, format, message);
        }
    }

    void logMessage(char level, String format) {
        if (this.mAppApi != null) {
            this.mAppApi.a(level, format, new Object[0]);
        }
    }
}

