package com.nielsen.simplenoadsandroidart.activities;

import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.nielsen.app.sdk.AppSdk;
import com.nielsen.app.sdk.IAppNotifier;
import com.nielsen.simplenoadsandroidart.R;
import com.nielsen.simplenoadsandroidart.models.NielsenInit;
import com.nielsen.simplenoadsandroidart.utils.Constants;

import java.io.IOException;


/**
 * Created by abdul on 06/02/18.
 */

public class LandingActivity extends AppCompatActivity implements IAppNotifier, View.OnClickListener {

    TextView txtOnlyContent, txtContentWith1Ad, txtDtvr, txtWebview, txtIpAdressText, txtGenerateUdid, txtPrivacy,
            txtOptOutStatus, txtVersion;
    static boolean isOptIn  = true;
    static AppSdk appSdk;
    AdvertisingIdClient.Info idInfo = null;
    boolean isLimitAdTrackingEnabled = false;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_landing);

        NielsenInit nielsenInit = new NielsenInit();
        appSdk = nielsenInit.initAppSdk(getApplicationContext(), this);

        initUI();
    }

    @Override
    protected void onResume() {
        super.onResume();
        //checkOptStatus();
        new generateAndFireID().execute();
    }

    private void initUI() {

        //Initialising UI elements
        txtOnlyContent = (TextView) findViewById(R.id.txtOnlyContent);
        txtContentWith1Ad = (TextView) findViewById(R.id.txtContentWith1Ad);
        txtDtvr = (TextView) findViewById(R.id.txtDtvr);
        txtWebview = (TextView) findViewById(R.id.txtWebview);
        txtIpAdressText = (TextView) findViewById(R.id.txtIpAdressText);
        txtOptOutStatus = (TextView) findViewById(R.id.txtOptOutStatus);
        txtGenerateUdid = (TextView) findViewById(R.id.txtGenerateUdid);
        txtPrivacy = (TextView) findViewById(R.id.txtPrivacy);
        txtVersion = (TextView) findViewById(R.id.txtVersion);

        txtVersion.setText(getResources().getString(R.string.sdk_version) + " " + appSdk.getMeterVersion());

        txtOnlyContent.setOnClickListener(this);
        txtContentWith1Ad.setOnClickListener(this);
        txtDtvr.setOnClickListener(this);
        txtWebview.setOnClickListener(this);
        txtGenerateUdid.setOnClickListener(this);
        txtPrivacy.setOnClickListener(this);


    }

    @Override
    public void onClick(View view) {
        switch (view.getId()){
            case R.id.txtOnlyContent:
                startActivity(new Intent(this, MainActivity.class)
                        .putExtra(Constants.INTENT_VIDEO_TYPE, Constants.onlyContent)
                        .putExtra(Constants.INTENT_TOTAL_VIDEOS, 1));
                break;
            case R.id.txtContentWith1Ad:
                startActivity(new Intent(this, MainActivity.class)
                        .putExtra(Constants.INTENT_VIDEO_TYPE, Constants.contentWithOneAd)
                        .putExtra(Constants.INTENT_TOTAL_VIDEOS, 2));
                break;
                case R.id.txtDtvr:
                startActivity(new Intent(this, MainActivity.class)
                        .putExtra(Constants.INTENT_VIDEO_TYPE, Constants.dtvrVideo)
                        .putExtra(Constants.INTENT_TOTAL_VIDEOS, 1));
                break;
                case R.id.txtWebview:
                    startActivity(new Intent(this, WebViewActivity.class));

                break;
            case R.id.txtPrivacy:
                startActivity(new Intent(this, OptOutActivity.class));
                break;
            case R.id.txtGenerateUdid:
                new generateAndFireID().execute();
                break;
        }
    }

    private class generateAndFireID extends AsyncTask<Void, Void, String> {
        @Override
        protected String doInBackground(Void... params) {

            String advertId = null;
            try {
                idInfo = AdvertisingIdClient.getAdvertisingIdInfo(getApplicationContext());
                isLimitAdTrackingEnabled = idInfo.isLimitAdTrackingEnabled();
                advertId = idInfo.getId();
            }
            catch (GooglePlayServicesNotAvailableException e) {
                e.printStackTrace();
            }
            catch (GooglePlayServicesRepairableException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            } catch (NullPointerException e){
                e.printStackTrace();
            }

            return advertId;
        }

        @Override
        protected void onPostExecute(String advertId) {
            checkOptStatus();
            txtIpAdressText.setText(advertId);
        }
    };

    private void checkOptStatus(){

        if(isLimitAdTrackingEnabled){
            txtOptOutStatus.setText(getString(R.string.device_opted_out));
        }else {
            txtOptOutStatus.setText(getString(R.string.device_opted_in));
        }
    }

    @Override
    public void onAppSdkEvent(long l, int i, String s) {
    }
}