//
//  LandingVC.swift
//  SimpleNoADSDKPods
//
//  Created by Abdul Rafay Mohd on 20/04/21.
//

import UIKit
import NielsenAppApi
import AppTrackingTransparency
import AdSupport

class LandingVC: UIViewController, NielsenAppApiDelegate {
    
    @IBOutlet weak var btnOnlyContent: UIButton!
    @IBOutlet weak var btnContentWithAd: UIButton!
    @IBOutlet weak var btnDtvr: UIButton!
    @IBOutlet weak var btnPrivacy: UIButton!
    @IBOutlet weak var btnsettings: UIButton!
    @IBOutlet weak var lblSDKVersion: UILabel!
    @IBOutlet weak var btnWebview: UIButton!
    @IBOutlet weak var lblATTrackingValue: UILabel!
    @IBOutlet weak var lblIDFA: UILabel!
    @IBOutlet weak var lblStatus: UILabel!
    
    var nielsenApi : NielsenAppApi!
    var sdkMethods : SDKMethods!
    var data : [String : Any]!
    var ipAddress:String?
    var isOptIn : Bool = true
    var OptStat :String?
    
    override func viewDidAppear(_ animated: Bool){
        super.viewDidAppear(animated)
        if (nielsenApi.optOutStatus == false) {
            lblStatus.text = ("Device currently Opted-In.")
        }
        else {
            lblStatus.text = ("Device Opted Out.")
        }
        OptStat = String(nielsenApi.optOutStatus)
  
        print("Optout status is", nielsenApi.optOutStatus)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.view.backgroundColor = UIColor(patternImage: UIImage(named: "new_background.jpg")!)
        let idfv = UIDevice.current.identifierForVendor?.uuidString
        
        self.lblIDFA.text = idfv
        
        setButtonBorderColor(button: btnOnlyContent)
        setButtonBorderColor(button: btnContentWithAd)
        setButtonBorderColor(button: btnDtvr)
        setButtonBorderColor(button: btnPrivacy)
        setButtonBorderColor(button: btnsettings)
        setButtonBorderColor(button: btnWebview)
  
        //Getting the instance of NielsenApi
         self.nielsenApi = NielsenInit.createNielsenApi(delegate: self)
        lblSDKVersion.text = "SDK Version: " + (self.nielsenApi.meterVersion ?? "")
        
         sdkMethods = SDKMethods()
         self.data = sdkMethods.loadStaticMaster()
         self.nielsenApi.loadMetadata(self.data)

    }

    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
          
        if segue.identifier == "segContent" {
            let videoController = segue.destination as? ViewController
            videoController?.videoType = Constants.onlyContent
            videoController?.totalVideos = 1
            videoController?.isOptIn = self.isOptIn
             videoController?.nielsenApi = nielsenApi
            
        }else if segue.identifier == "segContentAndAd" {
            
            let videoController = segue.destination as? ViewController
            videoController?.videoType = Constants.contentWithOneAd
            videoController?.totalVideos = 2
            videoController?.isOptIn = self.isOptIn
             videoController?.nielsenApi = nielsenApi
            
        }else if segue.identifier == "segWebView" {
            
            let videoController = segue.destination as? WebViewVC
            videoController?.nielsenApi = nielsenApi
            
        }else if segue.identifier == "segDTVR" {
            
            let videoController = segue.destination as? ViewController
            videoController?.videoType = Constants.dtvrVideo
            videoController?.totalVideos = 1
            videoController?.isOptIn = self.isOptIn
             videoController?.nielsenApi = nielsenApi
            
        }else if segue.identifier == "segPrivacy" {
                   
            let videoController = segue.destination as? OptOutVC
            videoController?.nielsenApi = nielsenApi
            
        }else if segue.identifier == "segSettings" {

   //         let settingsVC = segue.destination as! SettingsVC
   //         settingsVC.status = self.lblATTrackingValue.text
        }
    }
    

    func setButtonBorderColor(button : UIButton){
        
        button.layer.borderColor = UIColor.white.cgColor
    }
    
}
