//
//  PrivacyVC.swift
//  SimpleKidsSDKPods
//
//  Created by Abdul Rafay Mohd on 06/07/22.
//

import UIKit
import NielsenAppApi
import DropDown

class PrivacyVC: UIViewController{
    @IBOutlet weak var vwCountry: UIView!
    @IBOutlet weak var btnCountry: UIButton!
    @IBOutlet weak var lblCountryTitle: UILabel!
    
    @IBOutlet weak var vwLanguage: UIView!
    @IBOutlet weak var lblLanguage: UILabel!
    @IBOutlet weak var btnLanguage: UIButton!
    
    @IBOutlet weak var lblLegacy: UILabel!
    @IBOutlet weak var switchLegacy: UISwitch!
    @IBOutlet weak var btnLaunchPrivacy: UIButton!
    
    let dropDownCountry = DropDown()
    let countryArray = ["Australia",
                        "Czech Republic",
                        "Germany",
                        "italy",
                        "japan",
                        "norway",
                        "poland",
                        "thailand",
                        "United States"]
    
    let dropDownLanguage = DropDown()
    let languageArray = ["English","czech","German","Italian","Japanese","Norwegian Bokmål","Polish","Spanish"]
    
    var priv_url = ""
    var nielsenApi: NielsenAppApi!
    var country = ""
    var language = ""
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.view.backgroundColor = UIColor(patternImage: UIImage(named: "new_background.jpg")!)
        setButtonBorderColor(button: btnLaunchPrivacy)
        setCountryView()
        setLanguageView()
        setUrl()
    }
    
    func setCountryView(){
        btnCountry.titleLabel?.layer.opacity = 0.0
        lblCountryTitle.text = "Select Country"
        dropDownCountry.anchorView = vwCountry
        dropDownCountry.dataSource = countryArray
        dropDownCountry.bottomOffset = CGPoint(x:0,y:(dropDownCountry.anchorView?.plainView.bounds.height)!)
        dropDownCountry.topOffset = CGPoint(x:0,y:-(dropDownCountry.anchorView?.plainView.bounds.height)!)
        dropDownCountry.direction = .bottom
        dropDownCountry.selectionAction = { [unowned self] (index: Int, item: String) in
          print("Selected item: \(item) at index: \(index)")
            lblCountryTitle.text = countryArray[index]
            country = Constants.countryArray[index]
            setUrl()
        }
    }
    
    func setLanguageView(){
        btnLanguage.titleLabel?.layer.opacity = 0.0
        lblLanguage.text = "Select Language"
        dropDownLanguage.anchorView = vwLanguage
        dropDownLanguage.dataSource = languageArray
        dropDownLanguage.bottomOffset = CGPoint(x:0,y:(dropDownLanguage.anchorView?.plainView.bounds.height)!)
        dropDownLanguage.topOffset = CGPoint(x:0,y:-(dropDownLanguage.anchorView?.plainView.bounds.height)!)
        dropDownLanguage.direction = .bottom
        dropDownLanguage.selectionAction = { [unowned self] (index: Int, item: String) in
          print("Selected item: \(item) at index: \(index)")
            lblLanguage.text = languageArray[index]
            language = Constants.languageArray[index]
            setUrl()
        }
    }
    
    @IBAction func btnCountryTapped(_ sender: Any) {
        dropDownCountry.show()
    }
    @IBAction func btnLanguageTapped(_ sender: Any) {
        dropDownLanguage.show()
    }
    @IBAction func legacyValueChanged(_ sender: Any) {
        if(switchLegacy.isOn){
            lblLegacy.text = "Load OptOut Legacy URL"
            
        }else{
            lblLegacy.text = "Load normal OptOut URL"
            
        }
        setUrl()
    }
    
    func setUrl(){
        if(switchLegacy.isOn){
            priv_url = "https://priv-policy.imrworldwide.com/priv/mobile/" + country + "/" + language + "/optout_legacy.html"
        }else{
            priv_url = "https://priv-policy.imrworldwide.com/priv/mobile/" + country + "/" + language + "/optout.html"
        }
    }

    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        if segue.identifier == "segPrivacy" {
            
            let videoController = segue.destination as? OptOutVC
            videoController?.nielsenApi = nielsenApi
            videoController?.optOutURL = priv_url
            
        }
    }
    
    func setButtonBorderColor(button : UIButton){
        
        button.layer.borderColor = UIColor.white.cgColor
    }
}

